# PostgreSQLへ接続するドライバとしてpsycopg2を使用しています
# 下記サイトよりドライバの最新版をダウンロードしてインストールしてください
# https://pypi.org/project/psycopg2/

from os import getenv
import psycopg2
from psycopg2.extensions import connection

# 1) データベースへの接続情報 */
strCon = "host=localhost dbname=shop user=postgres password=test"

# 2) 変数の初期化
strResult = ""
strInsert = ""

strOldCompany = ""
strCurCompany = ""
intOldSale = 0
intCurSale = 0
strTrend = ""

# 3) PostgreSQLへの接続 */
connection = psycopg2.connect(strCon)
cursor = connection.cursor()

# 4) SELECT文の実行 */
cursor.execute('SELECT company, year, sale FROM Sales ORDER BY company, year, sale')
result=cursor.fetchall()

# 5) 結果セットを一行づつループ */
for row in result:

    # 6) 現在の企業を取得 */
    strCurCompany = row[0]
    intCurSale = row[2]

    # 7) 企業が同じ場合は株価を比較してtrendを計算 */
    if strOldCompany == strCurCompany:
        if intCurSale > intOldSale:
                strTrend = "+"
        elif intOldSale == intCurSale:
                strTrend = "="
        else:
                strTrend = "-" 
    else:
         strTrend = ""

    # 8) INSERT文を実行 
    strInsert = "INSERT INTO Sales2 (company, year, sale, var) VALUES ('" + strCurCompany + "', " + str(row[1]) + ", " + str(intCurSale) + ", '" + strTrend + "')"

    cursor.execute(strInsert)

    # 9) コミット
    connection.commit()

    intOldSale = intCurSale;
    strOldCompany = strCurCompany;

# 10) データベースとの接続を切断
cursor.close()
connection.close()
