■「リスト6.1::クロス結合を行うサンプルテーブル」を作成
※ 第3章で同一名の表を作成しているため、事前に削除してください。

CREATE TABLE Employees
(emp_id CHAR(8),
 emp_name VARCHAR(32),
 dept_id CHAR(2),
     CONSTRAINT pk_emp PRIMARY KEY(emp_id));

CREATE TABLE Departments
(dept_id CHAR(2),
 dept_name VARCHAR(32),
     CONSTRAINT pk_dep PRIMARY KEY(dept_id));

CREATE INDEX idx_dept_id ON Employees(dept_id);

INSERT INTO Employees VALUES('001',	'石田',	  '10');
INSERT INTO Employees VALUES('002',	'小笠原', '11');
INSERT INTO Employees VALUES('003',	'夏目',	  '11');
INSERT INTO Employees VALUES('004',	'米田',	  '12');
INSERT INTO Employees VALUES('005',	'釜本',	  '12');
INSERT INTO Employees VALUES('006',	'岩瀬',	  '12');

INSERT INTO Departments VALUES('10',	'総務');
INSERT INTO Departments VALUES('11',	'人事');
INSERT INTO Departments VALUES('12',	'開発');
INSERT INTO Departments VALUES('13',	'営業');


■リスト6.2 クロス結合
SELECT *
  FROM Employees
         CROSS JOIN
           Departments;

■リスト6.3 うっかりクロス結合：WHERE句に結合条件がない！
SELECT *
  FROM Employees, Departments;

■リスト6.4 内部結合を実行
SELECT E.emp_id, E.emp_name, E.dept_id, D.dept_name
  FROM Employees E INNER JOIN Departments D
    ON E.dept_id = D.dept_id;

■リスト6.5 リスト6.4を相関サブクエリで書き換えた例
SELECT E.emp_id, E.emp_name, E.dept_id,
       (SELECT D.dept_name
          FROM Departments D
         WHERE E.dept_id = D.dept_id) AS dept_name
  FROM Employees E;

■リスト6.6 左外部結合と右外部結合
--左外部結合の場合（左のテーブルがマスタ）
SELECT E.emp_id, E.emp_name, E.dept_id, D.dept_name
  FROM Departments D LEFT OUTER JOIN Employees E
    ON D.dept_id = E.dept_id;

--右外部結合の場合（右のテーブルがマスタ）
SELECT E.emp_id, E.emp_name, D.dept_id, D.dept_name
  FROM Employees E RIGHT OUTER JOIN Departments D
    ON E.dept_id = D.dept_id;


■「図6.5::自己結合を解説するための数字テーブル」を作成

CREATE TABLE Digits
(digit INTEGER PRIMARY KEY);

INSERT INTO Digits VALUES(0);
INSERT INTO Digits VALUES(1);
INSERT INTO Digits VALUES(2);
INSERT INTO Digits VALUES(3);
INSERT INTO Digits VALUES(4);
INSERT INTO Digits VALUES(5);
INSERT INTO Digits VALUES(6);
INSERT INTO Digits VALUES(7);
INSERT INTO Digits VALUES(8);
INSERT INTO Digits VALUES(9);


■リスト6.7 自己結合＋クロス結合
SELECT D1.digit + (D2.digit * 10) AS seq
  FROM Digits D1 CROSS JOIN Digits D2;

■リスト6.8 内部結合を実行（再掲）
SELECT E.emp_id, E.emp_name, E.dept_id, D.dept_name
  FROM Employees E INNER JOIN Departments D
    ON E.dept_id = D.dept_id;

■「三角結合を解説するためのテーブル」を作成

CREATE TABLE Table_A
(col_a CHAR(1));

CREATE TABLE Table_B
(col_b CHAR(1));

CREATE TABLE Table_C
(col_c CHAR(1));

■リスト6.9 三角結合の例
SELECT A.col_a, B.col_b, C.col_c
  FROM Table_A A
         INNER JOIN Table_B B
            ON A.col_a = B.col_b
              INNER JOIN Table_C C
                 ON A.col_a = C.col_c;

■リスト6.10 冗長な結合条件を追加
SELECT A.col_a, B.col_b, C.col_c
  FROM Table_A A
         INNER JOIN Table_B B
            ON A.col_a = B.col_b
               INNER JOIN Table_C C
                  ON A.col_a = C.col_c
                 AND C.col_c = B.col_b; 


■リスト6.11 EXISTS述語のサンプル
SELECT dept_id, dept_name
  FROM Departments D
 WHERE EXISTS (SELECT *
                 FROM Employees E
                WHERE E.dept_id = D.dept_id);

■リスト6.12 NOT EXISTS述語のサンプル
SELECT dept_id, dept_name
  FROM Departments D
 WHERE NOT EXISTS (SELECT *
                     FROM Employees E
                    WHERE E.dept_id = D.dept_id);


■リスト6.13 統計情報の収集
-- PostgreSQL
Analyze Departments;
Analyze Employees;

-- Oracle
exec DBMS_STATS.GATHER_TABLE_STATS(OWNNAME =>'TEST', TABNAME =>'Departments', CASCADE=>true, NO_INVALIDATE=>false);
exec DBMS_STATS.GATHER_TABLE_STATS(OWNNAME =>'TEST', TABNAME =>'Employees', CASCADE=>true, NO_INVALIDATE=>false);
※OWNNAMEは環境に応じて変えてください。

-- MySQL
Analyze Table Departments;
Analyze Table Employees;


-- OracleでNested Loops + インデックスレンジスキャンを効かせるヒント句のサンプル
SELECT /*+ LEADING(D E) USE_NL(E D) INDEX_RS_ASC(E) */ E.emp_id, E.emp_name, E.dept_id, D.dept_name 
  FROM Employees E INNER JOIN Departments D
    ON E.dept_id = D.dept_id;
