■リスト8.1 体重テーブルの定義
CREATE TABLE Weights
(student_id CHAR(4) PRIMARY KEY,
 weight     INTEGER);

INSERT INTO Weights VALUES('A100',	50);
INSERT INTO Weights VALUES('A101',	55);
INSERT INTO Weights VALUES('A124',	55);
INSERT INTO Weights VALUES('B343',	60);
INSERT INTO Weights VALUES('B346',	72);
INSERT INTO Weights VALUES('C563',	72);
INSERT INTO Weights VALUES('C345',	72);


■リスト8.2 主キーが1列の場合（ROW_NUMBER）
SELECT student_id,
       ROW_NUMBER() OVER (ORDER BY student_id) AS seq
  FROM Weights;

■リスト8.3 主キーが1列の場合（相関サブクエリ）
SELECT student_id,
       (SELECT COUNT(*)
          FROM Weights W2
         WHERE W2.student_id <= W1.student_id) AS seq
  FROM Weights W1;


■リスト8.4 体重テーブル2の定義
CREATE TABLE Weights2
(class      INTEGER NOT NULL,
 student_id CHAR(4) NOT NULL,
 weight INTEGER     NOT NULL,
   PRIMARY KEY(class, student_id));

INSERT INTO Weights2 VALUES(1, '100', 50);
INSERT INTO Weights2 VALUES(1, '101', 55);
INSERT INTO Weights2 VALUES(1, '102', 56);
INSERT INTO Weights2 VALUES(2, '100', 60);
INSERT INTO Weights2 VALUES(2, '101', 72);
INSERT INTO Weights2 VALUES(2, '102', 73);
INSERT INTO Weights2 VALUES(2, '103', 73);


■リスト8.5 主キーが複数列の場合（ROW_NUMBER）
SELECT class, student_id,
       ROW_NUMBER() OVER (ORDER BY class, student_id) AS seq
  FROM Weights2;

■リスト8.6 主キーが複数列の場合（相関サブクエリ：行式）
SELECT class, student_id,
       (SELECT COUNT(*)
          FROM Weights2 W2
         WHERE (W2.class, W2.student_id)
                 <= (W1.class, W1.student_id) ) AS seq
  FROM Weights2 W1;

■リスト8.7 クラスごとに連番を振る（ROW_NUMBER）
SELECT class, student_id,
       ROW_NUMBER() OVER (PARTITION BY class ORDER BY student_id) AS seq
  FROM Weights2;


■リスト8.8 体重テーブル3（連番列を埋めたい）

CREATE TABLE Weights3
(class      INTEGER NOT NULL,
 student_id CHAR(4) NOT NULL,
 weight INTEGER     NOT NULL,
 seq    INTEGER     NULL,
     PRIMARY KEY(class, student_id));

INSERT INTO Weights3 VALUES(1, '100', 50, NULL);
INSERT INTO Weights3 VALUES(1, '101', 55, NULL);
INSERT INTO Weights3 VALUES(1, '102', 56, NULL);
INSERT INTO Weights3 VALUES(2, '100', 60, NULL);
INSERT INTO Weights3 VALUES(2, '101', 72, NULL);
INSERT INTO Weights3 VALUES(2, '102', 73, NULL);
INSERT INTO Weights3 VALUES(2, '103', 73, NULL);

■リスト8.9 連番の更新（ROW_NUMBER）
UPDATE Weights3
   SET seq = (SELECT seq
                FROM (SELECT class, student_id,
                             ROW_NUMBER()
                               OVER (PARTITION BY class
                                         ORDER BY student_id) AS seq
                        FROM Weights3) SeqTbl
             -- SeqTblというサブクエリを作る必要がある
               WHERE Weights3.class = SeqTbl.class
                 AND Weights3.student_id = SeqTbl.student_id);


■リスト8.10 メジアンを求める（集合指向型）：母集合を上位と下位に分割する
SELECT AVG(weight)
  FROM (SELECT W1.weight
          FROM Weights W1, Weights W2
         GROUP BY W1.weight
            -- S1（下位集合）の条件
        HAVING SUM(CASE WHEN W2.weight >= W1.weight THEN 1 ELSE 0 END)
                  >= COUNT(*) / 2
            -- S2（上位集合）の条件
           AND SUM(CASE WHEN W2.weight <= W1.weight THEN 1 ELSE 0 END)
                  >= COUNT(*) / 2 ) TMP;


■リスト8.11 メジアンを求める（手続き型）：両端から1行ずつ数えてぶつかった地点が「世界の中心」
SELECT AVG(weight) AS median
  FROM (SELECT weight,
               ROW_NUMBER() OVER (ORDER BY weight ASC,  student_id ASC) AS hi,
               ROW_NUMBER() OVER (ORDER BY weight DESC, student_id DESC) AS lo
          FROM Weights) TMP
 WHERE hi IN (lo, lo +1 , lo -1);

■リスト8.12 メジアンを求める（手続き型その2）：折り返し地点を見つける
SELECT AVG(weight)
  FROM (SELECT weight,
               2 * ROW_NUMBER() OVER(ORDER BY weight)
                   - COUNT(*) OVER() AS diff
          FROM Weights) TMP
 WHERE diff BETWEEN 0 AND 2;

■リスト8.12 MySQL用
SELECT AVG(weight)
  FROM (SELECT weight, 
               2 * CAST(ROW_NUMBER() OVER(ORDER BY weight) AS SIGNED)
                   - COUNT(*) OVER() AS diff
         FROM Weights) TMP
 WHERE diff BETWEEN 0 AND 2;

■リスト8.13 連番テーブルの定義
CREATE TABLE Numbers( num INTEGER PRIMARY KEY);

INSERT INTO Numbers VALUES(1);
INSERT INTO Numbers VALUES(3); 
INSERT INTO Numbers VALUES(4); 
INSERT INTO Numbers VALUES(7); 
INSERT INTO Numbers VALUES(8); 
INSERT INTO Numbers VALUES(9); 
INSERT INTO Numbers VALUES(12);

■リスト8.14 欠番のカタマリを表示する
SELECT (N1.num + 1) AS gap_start,
       '～',
       (MIN(N2.num) - 1) AS gap_end
  FROM Numbers N1 INNER JOIN Numbers N2
    ON N2.num > N1.num
 GROUP BY N1.num
HAVING (N1.num + 1) < MIN(N2.num);

■リスト8.15 「1行あと」との比較
SELECT num + 1 AS gap_start,
       '～',
       (num + diff - 1) AS gap_end
  FROM (SELECT num,
               MAX(num)
                 OVER(ORDER BY num
                       ROWS BETWEEN 1 FOLLOWING
                                AND 1 FOLLOWING) - num AS diff
          FROM Numbers) TMP
 WHERE diff <> 1;

■リスト8.16 サブクエリの中身
SELECT num,
       MAX(num)
         OVER(ORDER BY num
               ROWS BETWEEN 1 FOLLOWING AND 1 FOLLOWING) AS next_num
  FROM Numbers;


■リスト8.17 シーケンスを求める（集合指向的）
SELECT MIN(num) AS low, 
       '〜',
       MAX(num) AS high
  FROM (SELECT N1.num,
               COUNT(N2.num) - N1.num AS gp
          FROM Numbers N1 INNER JOIN Numbers N2
            ON N2.num <= N1.num
         GROUP BY N1.num) N
 GROUP BY gp;


■リスト8.18 シーケンスを求める（手続き型）
SELECT MIN(num) AS start_num,
       '～',
       MAX(num) AS end_num
  FROM (SELECT num,
               num - ROW_NUMBER() OVER (ORDER BY num) AS group_id
          FROM Numbers) RankedNumbers
 GROUP BY group_id;


■リスト8.19 シーケンスオブジェクトの定義の例
CREATE SEQUENCE testseq
START WITH 1
INCREMENT BY 1
MAXVALUE 100000
MINVALUE 1
CYCLE;

■リスト8.20::シーケンスオブジェクトを使った行のINSERT例
INSERT INTO HogeTbl VALUES(NEXT VALUE FOR nextval, 'a', 'b', ...);


■リスト8.22 student_idを除外するとうまく動作しない
SELECT AVG(0weight) AS median
  FROM (SELECT weight,
               ROW_NUMBER() OVER (ORDER BY weight ASC) AS hi,
               ROW_NUMBER() OVER (ORDER BY weight DESC) AS lo
          FROM Weights) TMP
 WHERE hi IN (lo, lo +1 , lo -1);

■リスト8.23 サンプルデータ
DELETE FROM Weights;
INSERT INTO Weights VALUES('B346', 80);
INSERT INTO Weights VALUES('C563', 70);
INSERT INTO Weights VALUES('A100', 70);
INSERT INTO Weights VALUES('A124', 60);
INSERT INTO Weights VALUES('B343', 60);
INSERT INTO Weights VALUES('C345', 60);
