■リスト9.1 OmitTblテーブルの定義
CREATE TABLE OmitTbl
(keycol CHAR(8) NOT NULL,
 seq    INTEGER NOT NULL,
 val    INTEGER ,
  CONSTRAINT pk_OmitTbl PRIMARY KEY (keycol, seq));

INSERT INTO OmitTbl VALUES ('A', 1, 50);
INSERT INTO OmitTbl VALUES ('A', 2, NULL);
INSERT INTO OmitTbl VALUES ('A', 3, NULL);
INSERT INTO OmitTbl VALUES ('A', 4, 70);
INSERT INTO OmitTbl VALUES ('A', 5, NULL);
INSERT INTO OmitTbl VALUES ('A', 6, 900);
INSERT INTO OmitTbl VALUES ('B', 1, 10);
INSERT INTO OmitTbl VALUES ('B', 2, 20);
INSERT INTO OmitTbl VALUES ('B', 3, NULL);
INSERT INTO OmitTbl VALUES ('B', 4, 3);
INSERT INTO OmitTbl VALUES ('B', 5, NULL);
INSERT INTO OmitTbl VALUES ('B', 6, NULL);

■リスト9.2 OmitTblのUPDATE文
UPDATE OmitTbl
   SET val = (SELECT val
                FROM OmitTbl O1
               WHERE O1.keycol = OmitTbl.keycol				
                 AND O1.seq = (SELECT MAX(seq)
                                FROM OmitTbl O2
                               WHERE O2.keycol = OmitTbl.keycol
                                 AND O2.seq < OmitTbl.seq    
                                 AND O2.val IS NOT NULL))   
 WHERE val IS NULL;


■リスト9.3::NULLを埋め立てるUPDATE文：ウィンドウ関数を使う(IGNORE NULLS)
CREATE VIEW NoNULL (keycol, seq, val) AS
(SELECT keycol, seq,
        FIRST_VALUE(val) IGNORE NULLS 
                OVER(PARTITION BY keycol 
                         ORDER BY seq)
  FROM OmitTbl);

UPDATE OmitTbl
   SET val = (SELECT val
                FROM NoNULL NN
               WHERE OmitTbl.keycol = NN.keycol
                 AND OmitTbl.seq = NN.seq)
 WHERE val IS NULL;


■リスト9.4 埋め立ての逆演算SQL（UPDATE文）
UPDATE OmitTbl
   SET val = CASE WHEN val
                   = (SELECT val
                        FROM OmitTbl O1 
                       WHERE O1.keycol = OmitTbl.keycol
                         AND O1.seq
                                 = (SELECT MAX(seq)
                                      FROM OmitTbl O2
                                     WHERE O2.keycol = OmitTbl.keycol
                                       AND O2.seq < OmitTbl.seq))
             THEN NULL
             ELSE val END;


■リスト9.5::埋め立ての逆演算SQL（LAG関数を使う）
WITH VIEW_LAG (keycol, seq, pre_val) 
AS (SELECT keycol, seq, 
           LAG(val, 1) OVER(PARTITION BY keycol 
                                ORDER BY seq) 
      FROM OmitTbl)
UPDATE OmitTbl
   SET val = CASE WHEN (SELECT pre_val 
                          FROM VIEW_LAG
                         WHERE VIEW_LAG.keycol = OmitTbl.keycol
                           AND VIEW_LAG.seq = OmitTbl.seq) = val 
                  THEN NULL
                  ELSE val END;


■リスト9.6::行持ちの点数テーブルの定義
CREATE TABLE ScoreRows
(student_id CHAR(4)    NOT NULL,
 subject    VARCHAR(8) NOT NULL,
 score      INTEGER ,
  CONSTRAINT pk_ScoreRows PRIMARY KEY(student_id, subject));


INSERT INTO ScoreRows VALUES ('A001',	'英語',	100);
INSERT INTO ScoreRows VALUES ('A001',	'国語',	58);
INSERT INTO ScoreRows VALUES ('A001',	'数学',	90);
INSERT INTO ScoreRows VALUES ('B002',	'英語',	77);
INSERT INTO ScoreRows VALUES ('B002',	'国語',	60);
INSERT INTO ScoreRows VALUES ('C003',	'英語',	52);
INSERT INTO ScoreRows VALUES ('C003',	'国語',	49);
INSERT INTO ScoreRows VALUES ('C003',	'社会',	100);

■リスト9.7::列持ちの点数テーブルの定義
CREATE TABLE ScoreCols
(student_id CHAR(4)    NOT NULL,
 score_en      INTEGER ,
 score_nl      INTEGER ,
 score_mt      INTEGER ,
  CONSTRAINT pk_ScoreCols PRIMARY KEY (student_id));

INSERT INTO ScoreCols VALUES ('A001',	NULL, NULL, NULL);
INSERT INTO ScoreCols VALUES ('B002',	NULL, NULL, NULL);
INSERT INTO ScoreCols VALUES ('C003',	NULL, NULL, NULL);
INSERT INTO ScoreCols VALUES ('D004',	NULL, NULL, NULL);


■リスト9.8::行→列の更新SQL：素直だけど非効率
UPDATE ScoreCols
   SET score_en = (SELECT score
                     FROM ScoreRows SR
                    WHERE SR.student_id = ScoreCols.student_id
                      AND subject = '英語'),
       score_nl = (SELECT score
                     FROM ScoreRows SR
                    WHERE SR.student_id = ScoreCols.student_id
                      AND subject = '国語'),
       score_mt = (SELECT score
                     FROM ScoreRows SR
                    WHERE SR.student_id = ScoreCols.student_id
                      AND subject = '数学');


■リスト9.9 より効率的なSQL：リスト機能の利用
UPDATE ScoreCols
   SET (score_en, score_nl, score_mt) --複数列をリスト化して一度で更新
     = (SELECT MAX(CASE WHEN subject = '英語'
                        THEN score
                        ELSE NULL END) AS score_en,
               MAX(CASE WHEN subject = '国語'
                        THEN score
                        ELSE NULL END) AS score_nl,
               MAX(CASE WHEN subject = '数学'
                        THEN score
                        ELSE NULL END) AS score_mt
          FROM ScoreRows SR
          WHERE SR.student_id = ScoreCols.student_id);


■リスト9.10 ScoreColsNNテーブルの定義
CREATE TABLE ScoreColsNN
(student_id CHAR(4) NOT NULL,
 score_en INTEGER NOT NULL,
 score_nl INTEGER NOT NULL,
 score_mt INTEGER NOT NULL,
    CONSTRAINT pk_ScoreColsNN PRIMARY KEY (student_id));

INSERT INTO ScoreColsNN VALUES ('A001', 0, 0, 0);
INSERT INTO ScoreColsNN VALUES ('B002', 0, 0, 0);
INSERT INTO ScoreColsNN VALUES ('C003', 0, 0, 0);
INSERT INTO ScoreColsNN VALUES ('D004', 0, 0, 0);

■リスト9.11 リスト9.8（1列ずつ更新）のNOT NULL制約対応
UPDATE ScoreColsNN
   SET score_en = COALESCE((SELECT score 
                              FROM ScoreRows
                             WHERE student_id = ScoreColsNN.student_id
                               AND subject = '英語'), 0),
       score_nl = COALESCE((SELECT score
                              FROM ScoreRows
                             WHERE student_id = ScoreColsNN.student_id
                               AND subject = '国語'), 0),
       score_mt = COALESCE((SELECT score
                              FROM ScoreRows
                             WHERE student_id = ScoreColsNN.student_id
                               AND subject = '数学'), 0)
 WHERE EXISTS (SELECT * 
                 FROM ScoreRows
                WHERE student_id = ScoreColsNN.student_id);

■リスト9.12 リスト9.9（行式の利用）のNOT NULL制約対応
UPDATE ScoreColsNN 
   SET (score_en, score_nl, score_mt)
          = (SELECT COALESCE(MAX(CASE WHEN subject = '英語'
                                      THEN score
                                      ELSE NULL END), 0) AS score_en,
                    COALESCE(MAX(CASE WHEN subject = '国語'
                                      THEN score
                                      ELSE NULL END), 0) AS score_nl,
                    COALESCE(MAX(CASE WHEN subject = '数学'
                                      THEN score
                                      ELSE NULL END), 0) AS score_mt
               FROM ScoreRows SR
              WHERE SR.student_id = ScoreColsNN.student_id)
 WHERE EXISTS (SELECT * 
                 FROM ScoreRows
                WHERE student_id = ScoreColsNN.student_id);


■リスト9.13 MERGE文を利用して複数列を更新
MERGE INTO ScoreColsNN
   USING (SELECT student_id,
                 COALESCE(MAX(CASE WHEN subject = '英語'
                                   THEN score
                                   ELSE NULL END), 0) AS score_en,
                 COALESCE(MAX(CASE WHEN subject = '国語'
                                   THEN score
                                   ELSE NULL END), 0) AS score_nl,
                 COALESCE(MAX(CASE WHEN subject = '数学'
                                   THEN score
                                   ELSE NULL END), 0) AS score_mt
            FROM ScoreRows
           GROUP BY student_id) SR
      ON (ScoreColsNN.student_id = SR.student_id) 
    WHEN MATCHED THEN
         UPDATE SET ScoreColsNN.score_en = SR.score_en,
                    ScoreColsNN.score_nl = SR.score_nl,
                    ScoreColsNN.score_mt = SR.score_mt;


■リスト9.14 ScoreColsテーブルの定義
DELETE FROM ScoreCols;
INSERT INTO ScoreCols VALUES ('A001',100, 58, 90);
INSERT INTO ScoreCols VALUES ('B002', 77, 60, NULL);
INSERT INTO ScoreCols VALUES ('C003', 52, 49, NULL);
INSERT INTO ScoreCols VALUES ('D004', 10, 70, 100);

■リスト9.15 ScoreRowsテーブルの定義
DELETE FROM ScoreRows;
INSERT INTO ScoreRows VALUES ('A001', '英語', NULL);
INSERT INTO ScoreRows VALUES ('A001', '国語', NULL);
INSERT INTO ScoreRows VALUES ('A001', '数学', NULL);
INSERT INTO ScoreRows VALUES ('B002', '英語', NULL);
INSERT INTO ScoreRows VALUES ('B002', '国語', NULL);
INSERT INTO ScoreRows VALUES ('C003', '英語', NULL);
INSERT INTO ScoreRows VALUES ('C003', '国語', NULL);
INSERT INTO ScoreRows VALUES ('C003', '社会', NULL);


■リスト9.16 列→行の更新SQL
UPDATE ScoreRows
   SET score = (SELECT CASE ScoreRows.subject
                       WHEN '英語' THEN score_en
                       WHEN '国語' THEN score_nl
                       WHEN '数学' THEN score_mt
                       ELSE NULL END
                  FROM ScoreCols
                 WHERE student_id = ScoreRows.student_id);


■リスト9.17 更新元の株価テーブルの定義
CREATE TABLE Stocks
(brand      VARCHAR(8) NOT NULL,
 sale_date  DATE       NOT NULL,
 price      INTEGER    NOT NULL,
    CONSTRAINT pk_Stocks PRIMARY KEY (brand, sale_date));

INSERT INTO Stocks VALUES ('A鉄鋼', '2008-07-01', 1000);
INSERT INTO Stocks VALUES ('A鉄鋼', '2008-07-04', 1200);
INSERT INTO Stocks VALUES ('A鉄鋼', '2008-08-12', 800);
INSERT INTO Stocks VALUES ('B商社', '2008-06-04', 3000);
INSERT INTO Stocks VALUES ('B商社', '2008-09-11', 3000);
INSERT INTO Stocks VALUES ('C電気', '2008-07-01', 9000);
INSERT INTO Stocks VALUES ('D産業', '2008-06-04', 5000);
INSERT INTO Stocks VALUES ('D産業', '2008-06-05', 5000);
INSERT INTO Stocks VALUES ('D産業', '2008-06-06', 4800);
INSERT INTO Stocks VALUES ('D産業', '2008-12-01', 5100);


■リスト9.18 更新先の株価テーブルの定義
CREATE TABLE Stocks2
(brand      VARCHAR(8) NOT NULL,
 sale_date  DATE       NOT NULL,
 price      INTEGER    NOT NULL,
 trend      CHAR(3)    ,
    CONSTRAINT pk_Stocks2 PRIMARY KEY (brand, sale_date));

■リスト9.19 trend列を計算してINSERTする（相関サブクエリ）
INSERT INTO Stocks2
SELECT brand, sale_date, price,
       CASE SIGN(price -
                   (SELECT price
                      FROM Stocks S1
                     WHERE brand = Stocks.brand
                       AND sale_date =
                            (SELECT MAX(sale_date)
                               FROM Stocks S2
                              WHERE brand = Stocks.brand
                                AND sale_date < Stocks.sale_date)))
            WHEN -1 THEN '↓'
            WHEN 0 THEN '→'
            WHEN 1 THEN '↑'
            ELSE NULL
       END
  FROM Stocks;


■リスト9.20 trend列を計算してINSERTする（ウィンドウ関数）
INSERT INTO Stocks2
SELECT brand, sale_date, price,
       CASE SIGN(price -
                   MAX(price) OVER (PARTITION BY brand
                                        ORDER BY sale_date
                                    ROWS BETWEEN 1 PRECEDING
                                             AND 1 PRECEDING))
            WHEN -1 THEN '↓'
            WHEN 0 THEN '→'
            WHEN 1 THEN '↑'
            ELSE NULL
        END
  FROM Stocks S2;


■リスト9.21 Ordersテーブルの定義
CREATE TABLE Orders
( order_id INTEGER NOT NULL,
  order_shop VARCHAR(32) NOT NULL,
  order_name VARCHAR(32) NOT NULL,
  order_date DATE,
    PRIMARY KEY (order_id));

INSERT INTO Orders VALUES (10000, '東京', '後藤信二',   '2011/8/22');
INSERT INTO Orders VALUES (10001, '埼玉', '佐原商店',   '2011/9/1');
INSERT INTO Orders VALUES (10002, '千葉', '水原陽子',   '2011/9/20');
INSERT INTO Orders VALUES (10003, '山形', '加地健太郎', '2011/8/5');
INSERT INTO Orders VALUES (10004, '青森', '相原酒店',   '2011/8/22');
INSERT INTO Orders VALUES (10005, '長野', '宮元雄介',   '2011/8/29');

■リスト9.22 OrderReceiptsテーブルの定義
CREATE TABLE OrderReceipts
( order_id INTEGER NOT NULL,
  order_receipt_id INTEGER NOT NULL,
  item_group VARCHAR(32) NOT NULL,
  delivery_date DATE NOT NULL,
  PRIMARY KEY (order_id, order_receipt_id));

INSERT INTO OrderReceipts VALUES (10000, 1, '食器',           '2011/8/24');
INSERT INTO OrderReceipts VALUES (10000, 2, '菓子詰め合わせ', '2011/8/25');
INSERT INTO OrderReceipts VALUES (10000, 3, '牛肉',           '2011/8/26');
INSERT INTO OrderReceipts VALUES (10001, 1, '魚介類',         '2011/9/4');
INSERT INTO OrderReceipts VALUES (10002, 1, '菓子詰め合わせ', '2011/9/22');
INSERT INTO OrderReceipts VALUES (10002, 2, '調味料セット',   '2011/9/22');
INSERT INTO OrderReceipts VALUES (10003, 1, '米',             '2011/8/6');
INSERT INTO OrderReceipts VALUES (10003, 2, '牛肉',           '2011/8/10');
INSERT INTO OrderReceipts VALUES (10003, 3, '食器',           '2011/8/10');
INSERT INTO OrderReceipts VALUES (10004, 1, '野菜',           '2011/8/23');
INSERT INTO OrderReceipts VALUES (10005, 1, '飲料水',         '2011/8/30');
INSERT INTO OrderReceipts VALUES (10005, 2, '菓子詰め合わせ', '2011/8/30');

■リスト9.23 受付日と配送予定日の差分
SELECT O.order_id,
       O.order_name,
       ORC.delivery_date - O.order_date AS diff_days
  FROM Orders O
         INNER JOIN OrderReceipts ORC
            ON O.order_id = ORC.order_id
 WHERE ORC.delivery_date - O.order_date >= 3;


■リスト9.24 注文単位の集約
SELECT O.order_id,
       MAX(O.order_name),
       MAX(ORC.delivery_date - O.order_date) AS max_diff_days
  FROM Orders O
         INNER JOIN OrderReceipts ORC
            ON O.order_id = ORC.order_id
 WHERE ORC.delivery_date - O.order_date >= 3
 GROUP BY O.order_id;


■リスト9.25 集約関数を使う
SELECT O.order_id,
       MAX(O.order_name) AS order_name,
       MAX(O.order_date) AS order_date,
       COUNT(*) AS item_count
  FROM Orders O
        INNER JOIN OrderReceipts ORC
           ON O.order_id = ORC.order_id
 GROUP BY O.order_id;


■リスト9.26 ウィンドウ関数を使う
SELECT DISTINCT O.order_id, O.order_name, O.order_date,
       COUNT(*) OVER (PARTITION BY O.order_id) AS item_count
  FROM Orders O
       INNER JOIN OrderReceipts ORC
          ON O.order_id = ORC.order_id;


■リスト9.27 score列にNOT NULL制約を付けたテーブル定義
CREATE TABLE ScoreRowsNN
(student_id CHAR(4)    NOT NULL,
 subject    VARCHAR(8) NOT NULL,
 score      INTEGER    NOT NULL,
  CONSTRAINT pk_ScoreRowsNN PRIMARY KEY(student_id, subject));

INSERT INTO ScoreRowsNN VALUES ('A001', '英語', 0);
INSERT INTO ScoreRowsNN VALUES ('A001', '国語', 0);
INSERT INTO ScoreRowsNN VALUES ('A001', '数学', 0);
INSERT INTO ScoreRowsNN VALUES ('B002', '英語', 0);
INSERT INTO ScoreRowsNN VALUES ('B002', '国語', 0);
INSERT INTO ScoreRowsNN VALUES ('C003', '英語', 0);
INSERT INTO ScoreRowsNN VALUES ('C003', '国語', 0);
INSERT INTO ScoreRowsNN VALUES ('C003', '社会', 0);



