/*
    Copyright (C) 2010  C-LIS CO., LTD.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.co.c_lis.ccl.medicinesearch.android.entity;

import java.io.Serializable;

import jp.co.c_lis.ccl.medicinesearch.android.R;

public class Medicine implements Serializable {

    private static final long serialVersionUID = -295085756841934791L;

    // ID
    public String id = null;

    // 製品名
    String name = null;

    // 製薬会社名
    public String company = null;

    // 形状
    public String shape = null;

    // 効能・種別
    public String effect = null;

    // 識別コード - 包装
    String medicineCode1 = null;

    // 識別コード - 本体
    String medicineCode2 = null;

    // 種別
    int type = TYPE_NOTSET;

    // 詳細ページへのリンク
    String link = null;

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (value != null) {
            this.name = value.trim();
        } else {
            this.name = null;
        }
    }

    public static final int TYPE_NOTSET = 0; // 種別: 未設定
    public static final int TYPE_STORE = 1; // 種別: 市販薬
    public static final int TYPE_MEDICINE = 2; // 種別: 処方薬

    public int getType() {
        return this.type;
    }

    public void setType(String value) {
        if (value.equals("処方薬")) {
            type = TYPE_MEDICINE;
        } else if (value.equals("市販薬")) {
            type = TYPE_STORE;
        }
    }

    public boolean isTypeStore() {
        return (type == TYPE_STORE);
    }

    public boolean isTypeMedicine() {
        return (type == TYPE_MEDICINE);
    }

    public void setLink(String value) {
        if (value == null) return;

        this.link = value;
        String[] restArray = value.split("/");
        id = restArray[restArray.length - 1];
    }

    public String getMedicineCode1() {
        return this.medicineCode1;
    }

    public String getMedicineCode2() {
        return this.medicineCode2;
    }

    public void setMedicineCode(String value) {
        value = value.replace(" ", "");
        String[] codeArray = value.split("\\|");
        if (codeArray[0] != null) this.medicineCode1 = codeArray[0];
        if (codeArray[1] != null) this.medicineCode2 = codeArray[1];
    }

    /**
     * 薬情報を設定
     * 
     * @param data
     */
    public void setMedicine(Medicine data) {
        this.id = data.id;
        this.type = data.type;
        this.name = data.name;
        this.link = data.link;
        this.effect = data.effect;
        this.shape = data.shape;
        this.company = data.company;
        this.medicineCode1 = data.medicineCode1;
        this.medicineCode2 = data.medicineCode2;
    }

    public boolean validate() {
        if (name == null) return false;
        return true;
    }

    public int getLayoutId() {
        return R.layout.list;
    }

}
