/*
    Copyright (C) 2010  C-LIS CO., LTD.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.co.c_lis.ccl.medicinesearch.android.ui;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import jp.co.c_lis.ccl.medicinesearch.android.R;
import jp.co.c_lis.ccl.medicinesearch.android.entity.Medicine;
import jp.co.c_lis.ccl.medicinesearch.android.entity.MedicineDetail;
import jp.co.c_lis.ccl.medicinesearch.android.entity.MedicineDetail2;
import jp.co.c_lis.ccl.medicinesearch.android.net.YahooHealthServerInterface;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Gallery;
import android.widget.ImageView;
import android.widget.TextView;

public class DetailActivity extends BaseActivity {
    private static final boolean DEBUG_FLAG = false;
    private static final String LOG_TAG = "DetailActivity";

    public static final String EXTRA_MEDICINE = "jp.co.c_lis.ccl.medicinesearch.EXTRA_MEDICINE";

    private static final int HANDLE_START_LOAD = 0x01;
    private static final int HANDLE_FINISH_LOAD = 0x02;
    private final Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case HANDLE_START_LOAD:
                    mProgressDialog.show();
                    break;
                case HANDLE_FINISH_LOAD:
                    Medicine data = (Medicine) msg.obj;
                    if (data != null) {
                        switch (data.getLayoutId()) {
                            case R.layout.detail:
                                showMedicineDetail((MedicineDetail) data);
                                break;
                            case R.layout.detail2:
                                showMedicineDetail((MedicineDetail2) data);
                                break;
                        }
                        ;
                    }
                    mProgressDialog.dismiss();
                    break;
            }

        };
    };

    private ProgressDialog mProgressDialog = null;

    /**
     * ギャラリーに設定するアダプタクラス
     */
    public class ImageAdapter extends BaseAdapter {
        Context context = null;
        private final List<Bitmap> urlList = new LinkedList<Bitmap>();

        public List<Bitmap> getUrlList() {
            return this.urlList;
        }

        public ImageAdapter(Context c) {
            context = c;
        }

        public int getCount() {
            return urlList.size();
        }

        public Object getItem(int position) {
            return urlList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ImageView i = new ImageView(context);

            Bitmap bmp = (Bitmap) getItem(position);
            i.setImageBitmap(bmp);
            i.setLayoutParams(new Gallery.LayoutParams(bmp.getWidth(), bmp.getHeight()));

            return i;
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see android.app.Activity#onCreate(android.os.Bundle)
     */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        initProgressDialog();

        Intent intent = this.getIntent();
        if (intent != null) {
            Bundle data = intent.getExtras();
            Medicine medicine = (Medicine) data.getSerializable(EXTRA_MEDICINE);
            loadDetail(medicine);
        }
    }

    /**
     * プログレスダイアログの初期化
     */
    private void initProgressDialog() {
        if (mProgressDialog != null) return;
        mProgressDialog = new ProgressDialog(this);
        mProgressDialog.setCancelable(false);
        mProgressDialog.setTitle(R.string.retrieving);
        mProgressDialog.setMessage(getText(R.string.retrieve_message));
    }

    /**
     * 詳細情報をロード
     * 
     * @param data
     */
    private void loadDetail(final Medicine data) {

        Thread th = new Thread() {
            public void run() {
                mHandler.sendEmptyMessage(HANDLE_START_LOAD);

                Medicine result = null;
                try {
                    result = YahooHealthServerInterface.getMedicineDetail(data);
                } catch (IOException e) {
                    Log.e(LOG_TAG, e.getMessage());
                }

                Message msg = mHandler.obtainMessage();
                msg.what = HANDLE_FINISH_LOAD;
                msg.obj = result;
                mHandler.sendMessage(msg);
            }
        };
        th.start();
    }

    /**
     * 詳細情報を表示
     * 
     * @param data
     */
    private void showMedicineDetail(final MedicineDetail data) {
        setContentView(R.layout.detail);

        ((TextView) findViewById(R.id.tv_company)).setText(data.company);
        ((TextView) findViewById(R.id.tv_name)).setText(data.getName());
        ((TextView) findViewById(R.id.tv_effect)).setText(data.effect);
        ((TextView) findViewById(R.id.tv_shape)).setText(data.shape);
        ((TextView) findViewById(R.id.tv_type)).setText(getTypeStr(data));
        ((TextView) findViewById(R.id.tv_code1)).setText(data.getMedicineCode1());
        ((TextView) findViewById(R.id.tv_code2)).setText(data.getMedicineCode2());
        ((TextView) findViewById(R.id.tv_main_effect)).setText(data.mainEffect);
        ((TextView) findViewById(R.id.tv_side_effect)).setText(data.sideEffect);
        ((TextView) findViewById(R.id.tv_usage)).setText(data.usage);
        ((TextView) findViewById(R.id.tv_general_name)).setText(data.generalName);
        ((TextView) findViewById(R.id.tv_unit)).setText(data.unit);
        ((TextView) findViewById(R.id.tv_unit_price)).setText(String.valueOf(data.priceUnit));
        ((TextView) findViewById(R.id.tv_source)).setText(String.valueOf(data.source));

        final ImageAdapter adapter = new ImageAdapter(this);
        ((Gallery) findViewById(R.id.gal_pictures)).setAdapter(adapter);

        // 製品写真を取得して表示するスレッド
        Thread th = new Thread() {
            public void run() {
                List<Bitmap> list = adapter.getUrlList();
                list.clear();
                for (String url : data.imageList) {

                    // 製品写真を取得する
                    list.add(YahooHealthServerInterface.getImage(url));
                }

                // 取得したデータを反映
                mHandler.post(new Runnable() {
                    @Override
                    public void run() {
                        int visibility = View.VISIBLE;
                        if (adapter.getUrlList().size() == 0) {
                            visibility = View.GONE;
                        } else {
                            visibility = View.VISIBLE;
                        }

                        findViewById(R.id.tv_pictures_title).setVisibility(visibility);
                        findViewById(R.id.gal_pictures).setVisibility(visibility);
                        adapter.notifyDataSetChanged();
                    }
                });
            }
        };
        th.start();
    }

    /**
     * 詳細情報を表示
     * 
     * @param data
     */
    private void showMedicineDetail(MedicineDetail2 data) {
        setContentView(R.layout.detail2);

        ((TextView) findViewById(R.id.tv_name)).setText(data.getName());
        ((TextView) findViewById(R.id.tv_company)).setText(data.company);
        ((TextView) findViewById(R.id.tv_type)).setText(getTypeStr(data));
        ((TextView) findViewById(R.id.tv_especially)).setText(data.especially);
        ((TextView) findViewById(R.id.tv_element)).setText(String.valueOf(data.element));
        ((TextView) findViewById(R.id.tv_effect)).setText(data.effect);
        ((TextView) findViewById(R.id.tv_main_effect)).setText(data.mainEffect);
        ((TextView) findViewById(R.id.tv_usage)).setText(data.usage);
        ((TextView) findViewById(R.id.tv_shape)).setText(data.shape);
        ((TextView) findViewById(R.id.tv_parcel_and_price)).setText(data.getParcelAndPriceString());
        ((TextView) findViewById(R.id.tv_careful)).setText(String.valueOf(data.careful));
        ((TextView) findViewById(R.id.tv_risk_type)).setText(String.valueOf(data.riskType));
        ((TextView) findViewById(R.id.tv_source)).setText(String.valueOf(data.source));
    }

    /*
     * (non-Javadoc)
     * 
     * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {

        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.detail, menu);
        return super.onCreateOptionsMenu(menu);
    }

    /*
     * (non-Javadoc)
     * 
     * @see android.app.Activity#onMenuItemSelected(int, android.view.MenuItem)
     */
    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {

        switch (item.getItemId()) {
            case R.id.menu_detail_about:
                Dialog dialog = new Dialog(this);
                dialog.setTitle(R.string.app_name);
                dialog.setContentView(R.layout.about);
                dialog.show();
                break;
        }
        ;

        return super.onMenuItemSelected(featureId, item);
    }

}