/*
    Copyright (C) 2010  C-LIS CO., LTD.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.co.c_lis.ccl.medicinesearch.android.ui;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import jp.co.c_lis.ccl.medicinesearch.android.R;
import jp.co.c_lis.ccl.medicinesearch.android.entity.Medicine;
import jp.co.c_lis.ccl.medicinesearch.android.net.YahooHealthServerInterface;
import android.app.Dialog;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.View.OnClickListener;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.AbsListView.OnScrollListener;
import android.widget.AdapterView.OnItemClickListener;

public class ListActivity extends BaseActivity implements OnClickListener, OnItemClickListener {
    private static final boolean DEBUG_FLAG = false;
    private static final String LOG_TAG = "ListActivity";

    private volatile boolean mProcessing = false;
    private volatile boolean mHasNextPage = false;
    private volatile String mTermWord = null;
    private volatile int mNowPage = 0;

    private final Adapter mAdapter = new Adapter();
    private View mListFooterView = null;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.list);

        mListFooterView = View.inflate(this, R.layout.list_footer, null);
        mListFooterView.setVisibility(View.GONE);

        ListView mListView = (ListView) findViewById(R.id.lv_medicine);
        mListView.setOnItemClickListener(this);
        mListView.addFooterView(mListFooterView);
        mListView.setAdapter(mAdapter);
        mListView.setOnScrollListener(new OnScrollListener() {
            @Override
            public void onScrollStateChanged(AbsListView view, int scrollState) {}

            @Override
            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount,
                    int totalItemCount) {
                if ((mAdapter.getCount() == (firstVisibleItem + visibleItemCount - 1))
                        && mHasNextPage) {
                    startSearch();
                }
            }
        });

        findViewById(R.id.search_ib_exe).setOnClickListener(this);
        findViewById(R.id.search_layout).setVisibility(View.VISIBLE);
    }

    /**
     * 新規検索開始
     */
    private synchronized void startNewSearch() {
        EditText v = (EditText) findViewById(R.id.search_et_term);
        mTermWord = v.getText().toString();
        mAdapter.list.clear();
        mHasNextPage = false;
        mNowPage = 0;
        startSearch();
    }

    private final Handler mHandler = new Handler();

    /**
     * 検索開始
     */
    private synchronized void startSearch() {
        if (mProcessing != true) {
            Thread th = new Thread() {
                @Override
                public void run() {

                    // 検索開始の表示
                    mHandler.post(new Runnable() {
                        public void run() {
                            ListActivity.this.findViewById(R.id.search_layout).setVisibility(
                                    View.GONE);
                            mListFooterView.setVisibility(View.VISIBLE);
                        }
                    });

                    mNowPage++;
                    try {
                        YahooHealthServerInterface.MedicineList medicineList = YahooHealthServerInterface
                                .getMedicineList(mTermWord, mNowPage);
                        mHasNextPage = medicineList.hasNexePage();
                        mAdapter.list.addAll(medicineList.list);
                    } catch (IOException e) {}

                    // 検索結果の表示
                    mHandler.post(new Runnable() {
                        public void run() {
                            if (mHasNextPage == false) mListFooterView.setVisibility(View.GONE);
                            mAdapter.notifyDataSetChanged();
                        }
                    });
                    mProcessing = false;
                }
            };
            th.start();
            mProcessing = true;
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {

        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.list, menu);
        return super.onCreateOptionsMenu(menu);
    }

    /*
     * (non-Javadoc)
     * 
     * @see android.app.Activity#onMenuItemSelected(int, android.view.MenuItem)
     */
    @Override
    public boolean onMenuItemSelected(int featureId, MenuItem item) {

        switch (item.getItemId()) {
            case R.id.menu_list_search:
                View v = findViewById(R.id.search_layout);
                if (v.getVisibility() != View.VISIBLE) {
                    v.setVisibility(View.VISIBLE);
                } else {
                    v.setVisibility(View.GONE);
                }
                break;
            case R.id.menu_list_about:
                Dialog dialog = new Dialog(this);
                dialog.setTitle(R.string.app_name);
                dialog.setContentView(R.layout.about);
                dialog.show();
                break;
        }
        ;

        return super.onMenuItemSelected(featureId, item);
    }

    /*
     * (non-Javadoc)
     * 
     * @see android.view.View.OnClickListener#onClick(android.view.View)
     */
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.search_ib_exe:
                startNewSearch();
                break;
        }
    }

    /**
     * リストビューのアダプタ
     */
    private class Adapter extends BaseAdapter {

        final List<Medicine> list = new LinkedList<Medicine>();

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = View.inflate(ListActivity.this, R.layout.list_row, null);
                holder = new ViewHolder();
                holder.tvCompany = (TextView) convertView.findViewById(R.id.tv_company);
                holder.tvName = (TextView) convertView.findViewById(R.id.tv_name);
                holder.tvEffect = (TextView) convertView.findViewById(R.id.tv_effect);
                holder.tvShape = (TextView) convertView.findViewById(R.id.tv_shape);
                holder.tvType = (TextView) convertView.findViewById(R.id.tv_type);
                holder.tvCode1 = (TextView) convertView.findViewById(R.id.tv_code1);
                holder.tvCode2 = (TextView) convertView.findViewById(R.id.tv_code2);
                convertView.setTag(holder);
            } else {
                holder = (ViewHolder) convertView.getTag();
            }

            Medicine medicine = (Medicine) getItem(position);
            holder.tvCompany.setText(medicine.company);
            holder.tvName.setText(medicine.getName());
            holder.tvEffect.setText(medicine.effect);
            holder.tvShape.setText(medicine.shape);
            holder.tvType.setText(getTypeStr(medicine));
            holder.tvCode1.setText(medicine.getMedicineCode1());
            holder.tvCode2.setText(medicine.getMedicineCode2());

            return convertView;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public Object getItem(int arg0) {
            return list.get(arg0);
        }

        @Override
        public int getCount() {
            return list.size();
        }

    };

    private static class ViewHolder {
        TextView tvCompany = null;
        TextView tvName = null;
        TextView tvType = null;
        TextView tvEffect = null;
        TextView tvShape = null;
        TextView tvCode1 = null;
        TextView tvCode2 = null;
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * android.widget.AdapterView.OnItemClickListener#onItemClick(android.widget
     * .AdapterView, android.view.View, int, long)
     */
    @Override
    public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
        Medicine data = (Medicine) arg0.getItemAtPosition(arg2);
        Intent intent = new Intent(this, DetailActivity.class);
        intent.putExtra(DetailActivity.EXTRA_MEDICINE, data);
        startActivity(intent);
    }

}