package jp.co.c_lis.ccl.tmak.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.media.AudioManager;

public class AudioChangedReceiver extends BroadcastReceiver {

  @Override
  public void onReceive(Context context, Intent intent) {

  // 設定値を取得
  boolean enable = getEnable(context);

  // 設定が有効
  if(enable) {
      AudioManager mAudioManager
              = (AudioManager)context.getSystemService(Context.AUDIO_SERVICE);
      // 音量設定がサイレントの場合
      if(mAudioManager.getRingerMode() == AudioManager.RINGER_MODE_SILENT) {

          // バイブレーションモードに設定
          mAudioManager.setRingerMode(AudioManager.RINGER_MODE_VIBRATE);

      }
    }
  }

  private boolean getEnable(Context context) {

    // 設定のファイル名
    String settingFileName = context.getPackageName() + "_preferences";

    // 設定を取得
    SharedPreferences pref = context.getSharedPreferences(
            settingFileName, Context.MODE_PRIVATE);

    boolean result = pref.getBoolean("pref_key_enable_jammer", false);

    // 結果を返却
    return result;
  }
}
