/*
    Copyright (C) 2010  C-LIS CO., LTD.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.co.c_lis.ccl.medicinesearch.android.entity;

import java.util.LinkedList;
import java.util.List;

import jp.co.c_lis.ccl.medicinesearch.android.R;

public class MedicineDetail extends Medicine {

    private static final long serialVersionUID = -3418634917832514120L;

    // 一般名
    public String generalName = null;

    // 規格単位
    public String unit = null;

    // 薬価
    public float priceUnit = 0.0F;

    // 主な作用
    public String mainEffect = null;

    // 副作用など
    public String sideEffect = null;

    // 用い方と注意
    public String usage = null;

    // 製品写真
    public List<String> imageList = new LinkedList<String>();

    // 出典
    public String source = null;

    /**
     * コンストラクタ
     */
    public MedicineDetail() {}

    /**
     * コンストラクタ
     * 
     * @param base
     */
    public MedicineDetail(Medicine base) {
        setMedicine(base);
    }

    public void setMedicineCode(String value) {
        String[] codeArray = value.split("\n");
        String value1 = codeArray[1];
        String value2 = codeArray[3];

        medicineCode1 = value1.replace("包装：", "");
        medicineCode2 = value2.replace("本体：", "");
    }

    @Override
    public boolean validate() {
        if (super.validate() == false) return false;
        if (source == null) return false;
        return true;
    }

    @Override
    public int getLayoutId() {
        return R.layout.detail;
    }
}
