/*
    Copyright (C) 2010  C-LIS CO., LTD.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.co.c_lis.ccl.medicinesearch.android.entity;

import jp.co.c_lis.ccl.medicinesearch.android.R;

public class MedicineDetail2 extends Medicine {

    private static final long serialVersionUID = -3418634917832514120L;

    // 特徴
    public String especially = null;

    // 成分
    public String element = null;

    // 主な作用
    public String mainEffect = null;

    // 用法・用量
    public String usage = null;

    // 包装単位と希望小売価格
    private String[] parcelAndPrice = null;

    // 製品特有の注意
    public String careful = null;

    // リスク分類
    public String riskType = null;

    // 出典
    public String source = null;

    /**
     * コンストラクタ
     */
    public MedicineDetail2() {}

    /**
     * コンストラクタ
     * 
     * @param base
     */
    public MedicineDetail2(Medicine base) {
        setMedicine(base);
    }

    public void setParcelAndPrice(String value) {
        parcelAndPrice = value.split("/");
    }

    public String[] getParcelAndPrice() {
        return this.parcelAndPrice;
    }

    public String getParcelAndPriceString() {
        StringBuilder sb = new StringBuilder();
        if (this.parcelAndPrice == null) return sb.toString();

        for (String line : this.parcelAndPrice) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean validate() {
        if (super.validate() == false) return false;
        if (source == null) return false;
        return true;
    }

    @Override
    public int getLayoutId() {
        return R.layout.detail2;
    }

}
